<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AdministratorController;
use App\Http\Controllers\Api\AdvertisementController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\CommentController;
use App\Http\Controllers\Api\NewsController;
use App\Http\Controllers\Api\RatingController;
use App\Http\Controllers\Api\SubscriptionController;
use App\Http\Controllers\Api\UserController;



Route::get('/categories', [CategoryController::class, 'index']);
Route::post('/login', [UserController::class,'login']);
Route::post('/users', [UserController::class,'createUser']);


Route::middleware('auth:sanctum')->post('/logout/{id}', [UserController::class, 'logout']);
Route::middleware('auth:sanctum')->get('/advertisement/random', [AdvertisementController::class, 'getRandom']);
Route::middleware(['auth:sanctum','admin'])->get('/users', [UserController::class,'index']);

Route::prefix('administrator')
  ->middleware(['auth:sanctum','admin'])
  ->group(function(){
    Route::get('/', [AdministratorController::class,'index']);
    Route::post('/', [AdministratorController::class,'createAdmin']);
    Route::delete('/{id}', [AdministratorController::class,'deleteAdmin']);
});

Route::prefix('advertisement')
  ->middleware(['auth:sanctum','admin'])
  ->group(function(){
    Route::get('/', [AdvertisementController::class,'getAll']);
    Route::get('/{id}', [AdvertisementController::class,'show']);
    Route::post('/', [AdvertisementController::class,'store']);
    Route::delete('/{id}', [AdvertisementController::class,'deleteAdvertisement']);
    Route::post("/{id}",[AdvertisementController::class,"update"]);
  });

Route::prefix('comments')
  ->middleware(['auth:sanctum'])
  ->group(function(){
    Route::get('/', [CommentController::class,'getAll']);
    Route::get('/{id}', [CommentController::class,'getById']);
    Route::post('/', [CommentController::class,'createComment']);
  });


Route::prefix('news')
  ->middleware('auth:sanctum')
  ->group(function() {
  Route::get('/', [NewsController::class, 'getAll']);
  Route::get('/{id}', [NewsController::class, 'getById']);
  Route::get('/user/{id}', [NewsController::class, 'getByUserId']);
  Route::post('/', [NewsController::class, 'createNews']);
  Route::post('/{id}', [NewsController::class, 'updateNews']);
  Route::delete('/{id}', [NewsController::class, 'deleteNews']);
});

Route::prefix('ratings')
  ->middleware('auth:sanctum')
  ->group(function() {
  //Route::get('/', [RatingController::class,'index']);
  Route::get('/', [RatingController::class,'getByUser']);
  Route::post('/', [RatingController::class, 'createRating']);
  });


Route::prefix('subscriptions')
  ->middleware('auth:sanctum')
  ->group(function () {
    Route::get('/', [SubscriptionController::class, 'index'])->middleware('admin');      // GET /api/subscriptions
    Route::get('/{id}', [SubscriptionController::class, 'show']);   // Get /api/subscriptions/id_user
    Route::delete('/', [SubscriptionController::class, 'destroy']); // DELETE /api/subscriptions
    Route::post('/', [SubscriptionController::class, 'store']);     // CREATE /api/subscriptions
});

Route::prefix('users')
  ->middleware(['auth:sanctum'])
  ->group(function(){
    Route::get('/{id}', [UserController::class,'getById']);
    Route::put('/{id}', [UserController::class,'userUpdate']);
    Route::delete('/{id}', [UserController::class,'userDelete']);
    Route::post('/change-password', [UserController::class, 'changePassword']);
    Route::post('/change-photo/{id}', [UserController::class,'changePhoto']);
});
