<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ratings', function (Blueprint $table) {
          $table->uuid('id_usuarios');
          $table->uuid('id_noticias');
          $table->integer('valor');

          // Clave primaria compuesta
          $table->primary(['id_usuarios', 'id_noticias']);

          $table->foreign('id_usuarios')
                ->references('id')
                ->on('users')
                ->onDelete('cascade')
                ->onUpdate('cascade');

          $table->foreign('id_noticias')
                ->references('id')
                ->on('news')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
        DB::statement("ALTER TABLE ratings ADD CONSTRAINT chk_valor CHECK (valor BETWEEN 1 AND 5);");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
      DB::statement("ALTER TABLE ratings DROP CONSTRAINT IF EXISTS chk_valor;");
      Schema::dropIfExists('ratings');
    }
};
