<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
          $table->uuid('id_usuarios'); // Columna UUID
          $table->uuid('id_categorias'); // Columna UUID

          // Definir la clave primaria compuesta
          $table->primary(['id_usuarios', 'id_categorias']);

          // Definir las claves foráneas
          $table->foreign('id_usuarios')
                ->references('id')->on('users')
                ->onDelete('cascade')
                ->onUpdate('cascade');

          $table->foreign('id_categorias')
                ->references('id')->on('categories')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
