<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('comments', function (Blueprint $table) {
          $table->uuid('id')->default(DB::raw('uuid_generate_v4()'))->primary();
          $table->timestamp('fecha_comentario')->useCurrent();
          $table->text('texto');
          $table->uuid('id_usuarios');
          $table->uuid('id_noticias');
          $table->foreign('id_usuarios')
                ->references('id')->on('users')
                ->onDelete('cascade')
                ->onUpdate('cascade');

          $table->foreign('id_noticias')
                ->references('id')->on('news')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('comments');
    }
};
