<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('news', function (Blueprint $table) {
          $table->uuid('id')->default(DB::raw('uuid_generate_v4()'))->primary();
          $table->string('titulo');
          $table->text('descripcion')->nullable();
          $table->text('multimedia')->nullable();
          $table->string('pais', 20)->nullable();
          $table->string('autor')->nullable();
          $table->string('url')->nullable();
          $table->integer('vistas')->default(0);
          $table->timestamp('fecha_creacion')->default(now());
          $table->uuid('id_usuarios');
          $table->uuid('id_categorias');
          $table->foreign('id_usuarios')
                ->references('id')
                ->on('users')
                ->onDelete('set null')
                ->onUpdate('cascade');
          $table->foreign('id_categorias')
                ->references('id')
                ->on('categories')
                ->onDelete('restrict')
                ->onUpdate('cascade');
      });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('news');
    }
};
