<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      DB::statement('CREATE EXTENSION IF NOT EXISTS "uuid-ossp";');
        Schema::create('categories', function (Blueprint $table) {
          $table->uuid('id')->default(DB::raw('uuid_generate_v4()'))->primary();
          $table->string('categoria', 100)->unique();
        });
        DB::statement("ALTER TABLE categories ADD CONSTRAINT chk_categoria CHECK (categoria IN ('cientificas', 'culturales', 'deportivas','económicas','farándula','política','sociales','sucesos'));");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
      DB::statement("ALTER TABLE categories DROP CONSTRAINT IF EXISTS chk_categoria;");
      Schema::dropIfExists('categories');
    }
};
