<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('advertisements', function (Blueprint $table) {
          $table->uuid('id')->default(DB::raw('uuid_generate_v4()'))->primary();
          $table->string('titulo');
          $table->string('url');
          $table->string('multimedia')->nullable();
          $table->date('fecha_activacion');
          $table->date('fecha_fin');
          $table->date('fecha_publicacion');
          $table->uuid('id_administrador');
          $table->foreign('id_administrador')
                ->references('id')
                ->on('administrators')
                ->onDelete('set null')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('advertisements');
    }
};
