<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      DB::statement('CREATE EXTENSION IF NOT EXISTS "uuid-ossp";');
        Schema::create('users', function (Blueprint $table) {
          $table->uuid('id')->default(DB::raw('uuid_generate_v4()'))->primary();
          $table->string('correo', 50)->unique();
          $table->string('contrasena', 255);
          $table->string('nombre_usuario', 100);
          $table->string('nombre_completo', 255);
          $table->char('sexo', 1);
          $table->date('fecha_nacimiento');
      });
      DB::statement('ALTER TABLE users ADD CONSTRAINT chk_sexo CHECK (sexo IN (\'M\', \'F\'));');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
      DB::statement("ALTER TABLE users DROP CONSTRAINT IF EXISTS chk_sexo;");
      Schema::dropIfExists('users');
    }
};
