<?php

namespace App\Http\Middleware;

use App\Models\Administrator;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user(); // Obtener usuario autenticado

        if (!$user || !Administrator::where('id', $user->id)->exists()) {
            return response()->json(['message' => 'Acceso denegado. No eres administrador.'], 403);
        }

        return $next($request);
    }
}
